/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

#define M_PI	3.141593

vec2 tunnel(in vec2 pix, out float z);

void main(void)
{
	vec3 color = vec3(1.0, 1.0, 1.0);
	
	vec2 tc = gl_FragCoord.xy / iResolution.xy;
	
	float z;
	vec2 tun = tunnel(tc, z);
	
	color = vec3(clamp(2.0 / z, 0.0, 1.0)) * texture2D(iChannel0, tun).xyz;

	gl_FragColor.xyz = color;
	gl_FragColor.w = 1.0;
}

float psin(float x)
{
	return sin(x) * 0.5 + 0.5;
}

vec2 tunnel(in vec2 pix, out float z)
{
	float aspect = iResolution.x / iResolution.y;
	vec2 center = vec2(cos(iGlobalTime * 0.15), 0.0);
	vec2 pt = (pix * 2.0 - 1.0) * vec2(aspect, 1.0);
	
	vec2 dir = pt - center;
	
	float angle;
	angle = atan(dir.y, dir.x) / M_PI;
	float dist = sqrt(dot(dir, dir));
	z = 2.0 / dist;	

	return vec2(angle * 2.0 + iGlobalTime * 0.25, z + iGlobalTime * 0.5);
}